/******************************************************************************/
/****              Generated by IBExpert 12/04/2024 16:47:54               ****/
/******************************************************************************/

/******************************************************************************/
/****     Following SET SQL DIALECT is just for the Database Comparer      ****/
/******************************************************************************/


/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/


CREATE GENERATOR GEN_CONTROLE_ATUALI_VLR_TJSP_ID;

CREATE TABLE CONTROLE_ATUALIZAR_VLR_TJSP (
    CODIGO         DOM_CODIGO NOT NULL /* DOM_CODIGO = INTEGER */,
    NRO_CONTROLE   DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    DATA_INC       DOM_DATA_HORA /* DOM_DATA_HORA = DATE */,
    COD_USUARIO    DOM_CODIGO /* DOM_CODIGO = INTEGER */,
    DATA_FIM       DOM_DATA_HORA /* DOM_DATA_HORA = DATE */,
    DATA_CONTROLE  DOM_DATA_HORA /* DOM_DATA_HORA = DATE */
);



/******************************************************************************/
/****                             Primary keys                             ****/
/******************************************************************************/

ALTER TABLE CONTROLE_ATUALIZAR_VLR_TJSP ADD CONSTRAINT PK_CONTROLE_ATUALIZAR_VLR_TJSP PRIMARY KEY (CODIGO);


/******************************************************************************/
/****                               Triggers                               ****/
/******************************************************************************/



SET TERM ^ ;



/******************************************************************************/
/****                         Triggers for tables                          ****/
/******************************************************************************/



/* Trigger: CONTROLE_ATUA_VLR_TJSP_BI */
CREATE OR ALTER TRIGGER CONTROLE_ATUA_VLR_TJSP_BI FOR CONTROLE_ATUALIZAR_VLR_TJSP
ACTIVE BEFORE INSERT POSITION 0
as
begin
  if (new.codigo is null) then
    new.codigo = gen_id(GEN_CONTROLE_ATUALI_VLR_TJSP_ID,1);
end
^

/* Trigger: CONTROLE_ATUA_VLR_TJSP_CALCULAR */
CREATE OR ALTER TRIGGER CONTROLE_ATUA_VLR_TJSP_CALCULAR FOR CONTROLE_ATUALIZAR_VLR_TJSP
ACTIVE AFTER INSERT POSITION 5
AS
BEGIN
  EXECUTE PROCEDURE SP_ATUALIZAVLRTJ;
END
^

/* Trigger: CONTROLE_ATUA_VLR_TJSP_DATA_CON */
CREATE OR ALTER TRIGGER CONTROLE_ATUA_VLR_TJSP_DATA_CON FOR CONTROLE_ATUALIZAR_VLR_TJSP
ACTIVE BEFORE INSERT POSITION 3
AS
DECLARE VARIABLE INT_DIA INTEGER;
DECLARE VARIABLE DATA_AGORA DOM_DATA_HORA;
BEGIN
  INT_DIA = EXTRACT(DAY FROM CURRENT_TIMESTAMP);
  IF (:INT_DIA < 25) THEN
  BEGIN
    DATA_AGORA = DATEADD(MONTH, -1, CURRENT_TIMESTAMP);
    NEW.DATA_CONTROLE = CAST('25' || '.' || LPAD(EXTRACT(MONTH FROM :DATA_AGORA), 2, '0') || '.' || EXTRACT(YEAR FROM :DATA_AGORA) AS DATE);
  END
  ELSE
  BEGIN
    NEW.DATA_CONTROLE = CAST('25' || '.' || LPAD(EXTRACT(MONTH FROM CURRENT_TIMESTAMP), 2, '0') || '.' || EXTRACT(YEAR FROM CURRENT_TIMESTAMP) AS DATE);
  END
END
^

/* Trigger: CONTROLE_ATUA_VLR_TJSP_DATA_INC */
CREATE OR ALTER TRIGGER CONTROLE_ATUA_VLR_TJSP_DATA_INC FOR CONTROLE_ATUALIZAR_VLR_TJSP
ACTIVE BEFORE INSERT POSITION 1
AS
BEGIN
  NEW.DATA_INC = CURRENT_TIMESTAMP;
END
^

/* Trigger: CONTROLE_ATUA_VLR_TJSP_USUARIO */
CREATE OR ALTER TRIGGER CONTROLE_ATUA_VLR_TJSP_USUARIO FOR CONTROLE_ATUALIZAR_VLR_TJSP
ACTIVE BEFORE INSERT POSITION 2
AS
DECLARE VARIABLE I_TEMP INTEGER;
begin
   SELECT COD_USUARIO 
    FROM FUNCAO_COD_USUARIO 
    INTO :I_TEMP;
    NEW.COD_USUARIO = :I_TEMP;
end
^
SET TERM ; ^